/*
Copyright 2011 Daniel Morton. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice, this list
      of conditions and the following disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Daniel Morton ''AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those of the
authors and should not be interpreted as representing official policies, either expressed
or implied, of Daniel Morton.
*/

package ca.quadrilateral.blog.multifieldspringlogin.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

import ca.quadrilateral.blog.multifieldspringlogin.security.MultiFieldLoginUserDetails;

public class UserManagerService implements UserDetailsService {
	public static Collection<MultiFieldLoginUserDetails> userData = new ArrayList<MultiFieldLoginUserDetails>();
	
	static {
		userData.add(new MultiFieldLoginUserDetails("testuser1", "ACMECO", "password1", generateGrantedAuthorities("ROLE_USER", "ROLE_ADMIN")));
		userData.add(new MultiFieldLoginUserDetails("testuser2", "ACMECO", "password2", generateGrantedAuthorities("ROLE_USER")));
		userData.add(new MultiFieldLoginUserDetails("testuser1", "AACO", "password3", generateGrantedAuthorities("ROLE_USER", "ROLE_ADMIN")));
		userData.add(new MultiFieldLoginUserDetails("testuser2", "AACO", "password4", generateGrantedAuthorities("ROLE_USER")));
	}
	
	private static Collection<GrantedAuthority> generateGrantedAuthorities(String... authorityStrings) {
		Collection<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
		for(String authorityString : authorityStrings) {
			authorities.add(new GrantedAuthorityImpl(authorityString));
		}
		return authorities;
	}
	
	private UserDetails getUser(String username, String companyId) {
		for(MultiFieldLoginUserDetails userDataItem : userData) {
			if (userDataItem.getUsername().equals(username) && userDataItem.getCompanyId().equals(companyId)) {
				return userDataItem;
			}
		}	
		return null;
	}

	@Override
	public UserDetails loadUserByUsername(String username)
			throws UsernameNotFoundException, DataAccessException {
		final String[] split = StringUtils.splitPreserveAllTokens(username, "|");
		
		if (split.length != 2) {
            throw new IllegalArgumentException("Username and company id not supplied correctly.  Value: " + username);
		}
		
		final UserDetails result = getUser(split[0], split[1]);
		
		if (result == null) {
			throw new UsernameNotFoundException("Could not locate user with username: " + username);
		}
		return result;
	}
	
}
