<%--
Copyright 2011 Daniel Morton. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice, this list
      of conditions and the following disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Daniel Morton ''AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those of the
authors and should not be interpreted as representing official policies, either expressed
or implied, of Daniel Morton.
--%>

<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
	<head>
		<title>Multi-Field Login Example with Spring</title>
	</head>
	<body>
		<h1>Multi-Field Login Example with Spring</h1>
		<h2>Login Now!</h2>

         <form method="POST" action="j_spring_security_check">
            <c:if test="${not empty loginError && loginError}">
                <div class="error">
                    <h3>The login information specified was invalid.</h3>
                </div>
            </c:if>
            <c:if test="${not empty timeout && timeout}">
                <div class="error">
                    <h3>Your session has timed out.  You must log in again.</h3>
                </div>
            </c:if>
            <fieldset style="margin-top:5px;">
                 <span class="label"><label for="j_username">Username:</label></span>
                 <input id="j_username" name="j_username" type="text" /><br style="clear:both;" />

                 <span class="label"><label for="j_companyid">Company Id:</label></span>
                 <input id="j_agentid" name="j_companyid" type="text" /><br style="clear:both;" />

                 <span class="label"><label for="j_password">Password:</label></span>
                 <input id="j_password" name="j_password" type="password" /><br style="clear:both;" />
             </fieldset>
             <input type="submit" class="button" value="Login" />
         </form>
	</body>
</html>